package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{Mask, IpAddress, Dns, DefaultGateway}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StaticIpConnectionInfo(
    defaultGateway: DefaultGateway,
    dns: Iterable[Dns],
    ipAddress: IpAddress,
    mask: Mask
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo = {
    import StaticIpConnectionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo
      .builder()
      .defaultGateway(DefaultGateway.unwrap(defaultGateway): java.lang.String)
      .dns(dns.map { item =>
        Dns.unwrap(item): java.lang.String
      }.asJavaCollection)
      .ipAddress(IpAddress.unwrap(ipAddress): java.lang.String)
      .mask(Mask.unwrap(mask): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly =
    zio.aws.panorama.model.StaticIpConnectionInfo.wrap(buildAwsValue())
}
object StaticIpConnectionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.StaticIpConnectionInfo =
      zio.aws.panorama.model.StaticIpConnectionInfo(
        defaultGateway,
        dns,
        ipAddress,
        mask
      )
    def defaultGateway: DefaultGateway
    def dns: List[Dns]
    def ipAddress: IpAddress
    def mask: Mask
    def getDefaultGateway: ZIO[Any, Nothing, DefaultGateway] =
      ZIO.succeed(defaultGateway)
    def getDns: ZIO[Any, Nothing, List[Dns]] = ZIO.succeed(dns)
    def getIpAddress: ZIO[Any, Nothing, IpAddress] = ZIO.succeed(ipAddress)
    def getMask: ZIO[Any, Nothing, Mask] = ZIO.succeed(mask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo
  ) extends zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly {
    override val defaultGateway: DefaultGateway =
      zio.aws.panorama.model.primitives.DefaultGateway(impl.defaultGateway())
    override val dns: List[Dns] = impl
      .dns()
      .asScala
      .map { item =>
        zio.aws.panorama.model.primitives.Dns(item)
      }
      .toList
    override val ipAddress: IpAddress =
      zio.aws.panorama.model.primitives.IpAddress(impl.ipAddress())
    override val mask: Mask =
      zio.aws.panorama.model.primitives.Mask(impl.mask())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.StaticIpConnectionInfo
  ): zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly = new Wrapper(impl)
}
