package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait StatusFilter {
  def unwrap: software.amazon.awssdk.services.panorama.model.StatusFilter
}
object StatusFilter {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.StatusFilter
  ): zio.aws.panorama.model.StatusFilter = value match {
    case software.amazon.awssdk.services.panorama.model.StatusFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_SUCCEEDED =>
      val r = DEPLOYMENT_SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_ERROR =>
      val r = DEPLOYMENT_ERROR
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.REMOVAL_SUCCEEDED =>
      val r = REMOVAL_SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.REMOVAL_FAILED =>
      val r = REMOVAL_FAILED
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.PROCESSING_DEPLOYMENT =>
      val r = PROCESSING_DEPLOYMENT
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.PROCESSING_REMOVAL =>
      val r = PROCESSING_REMOVAL
      r
    case software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_FAILED =>
      val r = DEPLOYMENT_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOYMENT_SUCCEEDED extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_SUCCEEDED
  }
  case object DEPLOYMENT_ERROR extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_ERROR
  }
  case object REMOVAL_SUCCEEDED extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.REMOVAL_SUCCEEDED
  }
  case object REMOVAL_FAILED extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.REMOVAL_FAILED
  }
  case object PROCESSING_DEPLOYMENT
      extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.PROCESSING_DEPLOYMENT
  }
  case object PROCESSING_REMOVAL extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.PROCESSING_REMOVAL
  }
  case object DEPLOYMENT_FAILED extends zio.aws.panorama.model.StatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.StatusFilter =
      software.amazon.awssdk.services.panorama.model.StatusFilter.DEPLOYMENT_FAILED
  }
}
