package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{Bucket, Object}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StorageLocation(
    binaryPrefixLocation: Object,
    bucket: Bucket,
    generatedPrefixLocation: Object,
    manifestPrefixLocation: Object,
    repoPrefixLocation: Object
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.StorageLocation = {
    import StorageLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.StorageLocation
      .builder()
      .binaryPrefixLocation(
        Object.unwrap(binaryPrefixLocation): java.lang.String
      )
      .bucket(Bucket.unwrap(bucket): java.lang.String)
      .generatedPrefixLocation(
        Object.unwrap(generatedPrefixLocation): java.lang.String
      )
      .manifestPrefixLocation(
        Object.unwrap(manifestPrefixLocation): java.lang.String
      )
      .repoPrefixLocation(Object.unwrap(repoPrefixLocation): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.StorageLocation.ReadOnly =
    zio.aws.panorama.model.StorageLocation.wrap(buildAwsValue())
}
object StorageLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.StorageLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.StorageLocation =
      zio.aws.panorama.model.StorageLocation(
        binaryPrefixLocation,
        bucket,
        generatedPrefixLocation,
        manifestPrefixLocation,
        repoPrefixLocation
      )
    def binaryPrefixLocation: Object
    def bucket: Bucket
    def generatedPrefixLocation: Object
    def manifestPrefixLocation: Object
    def repoPrefixLocation: Object
    def getBinaryPrefixLocation: ZIO[Any, Nothing, Object] =
      ZIO.succeed(binaryPrefixLocation)
    def getBucket: ZIO[Any, Nothing, Bucket] = ZIO.succeed(bucket)
    def getGeneratedPrefixLocation: ZIO[Any, Nothing, Object] =
      ZIO.succeed(generatedPrefixLocation)
    def getManifestPrefixLocation: ZIO[Any, Nothing, Object] =
      ZIO.succeed(manifestPrefixLocation)
    def getRepoPrefixLocation: ZIO[Any, Nothing, Object] =
      ZIO.succeed(repoPrefixLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.StorageLocation
  ) extends zio.aws.panorama.model.StorageLocation.ReadOnly {
    override val binaryPrefixLocation: Object =
      zio.aws.panorama.model.primitives.Object(impl.binaryPrefixLocation())
    override val bucket: Bucket =
      zio.aws.panorama.model.primitives.Bucket(impl.bucket())
    override val generatedPrefixLocation: Object =
      zio.aws.panorama.model.primitives.Object(impl.generatedPrefixLocation())
    override val manifestPrefixLocation: Object =
      zio.aws.panorama.model.primitives.Object(impl.manifestPrefixLocation())
    override val repoPrefixLocation: Object =
      zio.aws.panorama.model.primitives.Object(impl.repoPrefixLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.StorageLocation
  ): zio.aws.panorama.model.StorageLocation.ReadOnly = new Wrapper(impl)
}
