package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{TagValue, TagKey, ResourceArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.TagResourceRequest.ReadOnly =
    zio.aws.panorama.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.TagResourceRequest =
      zio.aws.panorama.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ResourceArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.TagResourceRequest
  ) extends zio.aws.panorama.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.panorama.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.panorama.model.primitives
          .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.TagResourceRequest
  ): zio.aws.panorama.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
