package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait TemplateType {
  def unwrap: software.amazon.awssdk.services.panorama.model.TemplateType
}
object TemplateType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.TemplateType
  ): zio.aws.panorama.model.TemplateType = value match {
    case software.amazon.awssdk.services.panorama.model.TemplateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.TemplateType.RTSP_CAMERA_STREAM =>
      val r = RTSP_CAMERA_STREAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.TemplateType =
      software.amazon.awssdk.services.panorama.model.TemplateType.UNKNOWN_TO_SDK_VERSION
  }
  case object RTSP_CAMERA_STREAM extends zio.aws.panorama.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.TemplateType =
      software.amazon.awssdk.services.panorama.model.TemplateType.RTSP_CAMERA_STREAM
  }
}
