package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{DeviceId, Description}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDeviceMetadataRequest(
    description: Optional[Description] = Optional.Absent,
    deviceId: DeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest = {
    import UpdateDeviceMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.UpdateDeviceMetadataRequest.ReadOnly =
    zio.aws.panorama.model.UpdateDeviceMetadataRequest.wrap(buildAwsValue())
}
object UpdateDeviceMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.UpdateDeviceMetadataRequest =
      zio.aws.panorama.model
        .UpdateDeviceMetadataRequest(description.map(value => value), deviceId)
    def description: Optional[Description]
    def deviceId: DeviceId
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest
  ) extends zio.aws.panorama.model.UpdateDeviceMetadataRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val deviceId: DeviceId =
      zio.aws.panorama.model.primitives.DeviceId(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataRequest
  ): zio.aws.panorama.model.UpdateDeviceMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
