package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.DeviceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDeviceMetadataResponse(
    deviceId: Optional[DeviceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse = {
    import UpdateDeviceMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly =
    zio.aws.panorama.model.UpdateDeviceMetadataResponse.wrap(buildAwsValue())
}
object UpdateDeviceMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.UpdateDeviceMetadataResponse =
      zio.aws.panorama.model
        .UpdateDeviceMetadataResponse(deviceId.map(value => value))
    def deviceId: Optional[DeviceId]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse
  ) extends zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly {
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.UpdateDeviceMetadataResponse
  ): zio.aws.panorama.model.UpdateDeviceMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
