package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait UpdateProgress {
  def unwrap: software.amazon.awssdk.services.panorama.model.UpdateProgress
}
object UpdateProgress {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.UpdateProgress
  ): zio.aws.panorama.model.UpdateProgress = value match {
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.VERIFYING =>
      val r = VERIFYING
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.REBOOTING =>
      val r = REBOOTING
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.DOWNLOADING =>
      val r = DOWNLOADING
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.panorama.model.UpdateProgress.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.PENDING
  }
  case object IN_PROGRESS extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.IN_PROGRESS
  }
  case object VERIFYING extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.VERIFYING
  }
  case object REBOOTING extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.REBOOTING
  }
  case object DOWNLOADING extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.DOWNLOADING
  }
  case object COMPLETED extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.COMPLETED
  }
  case object FAILED extends zio.aws.panorama.model.UpdateProgress {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.UpdateProgress =
      software.amazon.awssdk.services.panorama.model.UpdateProgress.FAILED
  }
}
