package zio.aws.panorama
import zio.aws.panorama.model.primitives.JobId.Type
import java.time.Instant
import zio.aws.panorama.model.primitives.{
  TemplateKey,
  DeviceId,
  IpAddressOrServerName,
  Dns,
  PrincipalArn,
  TagValue,
  TemplateValue,
  TagKey
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ApplicationInstanceArn extends Subtype[String]
    type ApplicationInstanceArn =
      zio.aws.panorama.model.primitives.ApplicationInstanceArn.Type
    object ApplicationInstanceId extends Subtype[String]
    type ApplicationInstanceId =
      zio.aws.panorama.model.primitives.ApplicationInstanceId.Type
    object ApplicationInstanceName extends Subtype[String]
    type ApplicationInstanceName =
      zio.aws.panorama.model.primitives.ApplicationInstanceName.Type
    object ApplicationInstanceStatusDescription extends Subtype[String]
    type ApplicationInstanceStatusDescription =
      zio.aws.panorama.model.primitives.ApplicationInstanceStatusDescription.Type
    object Bucket extends Subtype[String]
    type Bucket = zio.aws.panorama.model.primitives.Bucket.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.panorama.model.primitives.BucketName.Type
    object Certificates extends Subtype[Chunk[Byte]]
    type Certificates = zio.aws.panorama.model.primitives.Certificates.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.panorama.model.primitives.ClientToken.Type
    object CreatedTime extends Subtype[Instant]
    type CreatedTime = zio.aws.panorama.model.primitives.CreatedTime.Type
    object CurrentSoftware extends Subtype[String]
    type CurrentSoftware =
      zio.aws.panorama.model.primitives.CurrentSoftware.Type
    object DefaultGateway extends Subtype[String]
    type DefaultGateway = zio.aws.panorama.model.primitives.DefaultGateway.Type
    object DefaultRuntimeContextDevice extends Subtype[String]
    type DefaultRuntimeContextDevice =
      zio.aws.panorama.model.primitives.DefaultRuntimeContextDevice.Type
    object Description extends Subtype[String]
    type Description = zio.aws.panorama.model.primitives.Description.Type
    object DeviceArn extends Subtype[String]
    type DeviceArn = zio.aws.panorama.model.primitives.DeviceArn.Type
    object DeviceId extends Subtype[String]
    type DeviceId = zio.aws.panorama.model.primitives.DeviceId.Type
    object DeviceName extends Subtype[String]
    type DeviceName = zio.aws.panorama.model.primitives.DeviceName.Type
    object DeviceSerialNumber extends Subtype[String]
    type DeviceSerialNumber =
      zio.aws.panorama.model.primitives.DeviceSerialNumber.Type
    object Dns extends Subtype[String]
    type Dns = zio.aws.panorama.model.primitives.Dns.Type
    object HwAddress extends Subtype[String]
    type HwAddress = zio.aws.panorama.model.primitives.HwAddress.Type
    object ImageVersion extends Subtype[String]
    type ImageVersion = zio.aws.panorama.model.primitives.ImageVersion.Type
    object IotThingName extends Subtype[String]
    type IotThingName = zio.aws.panorama.model.primitives.IotThingName.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.panorama.model.primitives.IpAddress.Type
    object IpAddressOrServerName extends Subtype[String]
    type IpAddressOrServerName =
      zio.aws.panorama.model.primitives.IpAddressOrServerName.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.panorama.model.primitives.JobId.Type
    object LastUpdatedTime extends Subtype[Instant]
    type LastUpdatedTime =
      zio.aws.panorama.model.primitives.LastUpdatedTime.Type
    object LatestAlternateSoftware extends Subtype[String]
    type LatestAlternateSoftware =
      zio.aws.panorama.model.primitives.LatestAlternateSoftware.Type
    object LatestSoftware extends Subtype[String]
    type LatestSoftware = zio.aws.panorama.model.primitives.LatestSoftware.Type
    object LeaseExpirationTime extends Subtype[Instant]
    type LeaseExpirationTime =
      zio.aws.panorama.model.primitives.LeaseExpirationTime.Type
    object ManifestOverridesPayloadData extends Subtype[String]
    type ManifestOverridesPayloadData =
      zio.aws.panorama.model.primitives.ManifestOverridesPayloadData.Type
    object ManifestPayloadData extends Subtype[String]
    type ManifestPayloadData =
      zio.aws.panorama.model.primitives.ManifestPayloadData.Type
    object MarkLatestPatch extends Subtype[Boolean]
    type MarkLatestPatch =
      zio.aws.panorama.model.primitives.MarkLatestPatch.Type
    object Mask extends Subtype[String]
    type Mask = zio.aws.panorama.model.primitives.Mask.Type
    object MaxConnections extends Subtype[Int]
    type MaxConnections = zio.aws.panorama.model.primitives.MaxConnections.Type
    object MaxSize25 extends Subtype[Int]
    type MaxSize25 = zio.aws.panorama.model.primitives.MaxSize25.Type
    object NameFilter extends Subtype[String]
    type NameFilter = zio.aws.panorama.model.primitives.NameFilter.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.panorama.model.primitives.NextToken.Type
    object NodeAssetName extends Subtype[String]
    type NodeAssetName = zio.aws.panorama.model.primitives.NodeAssetName.Type
    object NodeFromTemplateJobStatusMessage extends Subtype[String]
    type NodeFromTemplateJobStatusMessage =
      zio.aws.panorama.model.primitives.NodeFromTemplateJobStatusMessage.Type
    object NodeId extends Subtype[String]
    type NodeId = zio.aws.panorama.model.primitives.NodeId.Type
    object NodeInstanceId extends Subtype[String]
    type NodeInstanceId = zio.aws.panorama.model.primitives.NodeInstanceId.Type
    object NodeName extends Subtype[String]
    type NodeName = zio.aws.panorama.model.primitives.NodeName.Type
    object NodePackageArn extends Subtype[String]
    type NodePackageArn = zio.aws.panorama.model.primitives.NodePackageArn.Type
    object NodePackageId extends Subtype[String]
    type NodePackageId = zio.aws.panorama.model.primitives.NodePackageId.Type
    object NodePackageName extends Subtype[String]
    type NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName.Type
    object NodePackagePatchVersion extends Subtype[String]
    type NodePackagePatchVersion =
      zio.aws.panorama.model.primitives.NodePackagePatchVersion.Type
    object NodePackageVersion extends Subtype[String]
    type NodePackageVersion =
      zio.aws.panorama.model.primitives.NodePackageVersion.Type
    object NtpServerName extends Subtype[String]
    type NtpServerName = zio.aws.panorama.model.primitives.NtpServerName.Type
    object Object extends Subtype[String]
    type Object = zio.aws.panorama.model.primitives.Object.Type
    object ObjectKey extends Subtype[String]
    type ObjectKey = zio.aws.panorama.model.primitives.ObjectKey.Type
    object PackageImportJobStatusMessage extends Subtype[String]
    type PackageImportJobStatusMessage =
      zio.aws.panorama.model.primitives.PackageImportJobStatusMessage.Type
    object PackageOwnerAccount extends Subtype[String]
    type PackageOwnerAccount =
      zio.aws.panorama.model.primitives.PackageOwnerAccount.Type
    object PackageVersionStatusDescription extends Subtype[String]
    type PackageVersionStatusDescription =
      zio.aws.panorama.model.primitives.PackageVersionStatusDescription.Type
    object PortDefaultValue extends Subtype[String]
    type PortDefaultValue =
      zio.aws.panorama.model.primitives.PortDefaultValue.Type
    object PortName extends Subtype[String]
    type PortName = zio.aws.panorama.model.primitives.PortName.Type
    object PrincipalArn extends Subtype[String]
    type PrincipalArn = zio.aws.panorama.model.primitives.PrincipalArn.Type
    object Region extends Subtype[String]
    type Region = zio.aws.panorama.model.primitives.Region.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.panorama.model.primitives.ResourceArn.Type
    object RuntimeContextName extends Subtype[String]
    type RuntimeContextName =
      zio.aws.panorama.model.primitives.RuntimeContextName.Type
    object RuntimeRoleArn extends Subtype[String]
    type RuntimeRoleArn = zio.aws.panorama.model.primitives.RuntimeRoleArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.panorama.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.panorama.model.primitives.TagValue.Type
    object TemplateKey extends Subtype[String]
    type TemplateKey = zio.aws.panorama.model.primitives.TemplateKey.Type
    object TemplateValue extends Subtype[String]
    type TemplateValue = zio.aws.panorama.model.primitives.TemplateValue.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.panorama.model.primitives.TimeStamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.panorama.model.primitives.Token.Type
    object UpdateCreatedTime extends Subtype[Instant]
    type UpdateCreatedTime =
      zio.aws.panorama.model.primitives.UpdateCreatedTime.Type
    object Version extends Subtype[String]
    type Version = zio.aws.panorama.model.primitives.Version.Type
  }
  type AlternateSoftwares =
    List[zio.aws.panorama.model.AlternateSoftwareMetadata]
  type ApplicationInstances = List[zio.aws.panorama.model.ApplicationInstance]
  type DeviceIdList = List[DeviceId]
  type DeviceJobList = List[zio.aws.panorama.model.DeviceJob]
  type DeviceList = List[zio.aws.panorama.model.Device]
  type DnsList = List[Dns]
  type InputPortList = List[zio.aws.panorama.model.NodeInputPort]
  type JobList = List[zio.aws.panorama.model.Job]
  type JobTagsList = List[zio.aws.panorama.model.JobResourceTags]
  type NodeFromTemplateJobList =
    List[zio.aws.panorama.model.NodeFromTemplateJob]
  type NodeInstances = List[zio.aws.panorama.model.NodeInstance]
  type NodeSignalList = List[zio.aws.panorama.model.NodeSignal]
  type NodesList = List[zio.aws.panorama.model.Node]
  type NtpServerList = List[IpAddressOrServerName]
  type OutputPortList = List[zio.aws.panorama.model.NodeOutputPort]
  type PackageImportJobList = List[zio.aws.panorama.model.PackageImportJob]
  type PackageList = List[zio.aws.panorama.model.PackageListItem]
  type PackageObjects = List[zio.aws.panorama.model.PackageObject]
  type PrincipalArnsList = List[PrincipalArn]
  type ReportedRuntimeContextStates =
    List[zio.aws.panorama.model.ReportedRuntimeContextState]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TemplateParametersMap = Map[TemplateKey, TemplateValue]
}
