package zio.aws.pcs
import zio.aws.pcs.model.GetClusterResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pcs.model.{
  CreateQueueResponse,
  RegisterComputeNodeGroupInstanceResponse,
  UpdateComputeNodeGroupResponse,
  RegisterComputeNodeGroupInstanceRequest,
  ListQueuesRequest,
  DeleteQueueRequest,
  CreateComputeNodeGroupResponse,
  UpdateQueueRequest,
  CreateQueueRequest,
  ListTagsForResourceRequest,
  DeleteQueueResponse,
  GetComputeNodeGroupRequest,
  ComputeNodeGroupSummary,
  ListComputeNodeGroupsRequest,
  GetClusterRequest,
  CreateClusterRequest,
  QueueSummary,
  GetQueueResponse,
  UpdateQueueResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetClusterResponse,
  CreateClusterResponse,
  DeleteClusterRequest,
  ListQueuesResponse,
  DeleteComputeNodeGroupResponse,
  CreateComputeNodeGroupRequest,
  UpdateComputeNodeGroupRequest,
  UntagResourceRequest,
  GetQueueRequest,
  ClusterSummary,
  GetComputeNodeGroupResponse,
  DeleteClusterResponse,
  ListComputeNodeGroupsResponse,
  TagResourceResponse,
  ListClustersRequest,
  TagResourceRequest,
  DeleteComputeNodeGroupRequest,
  ListClustersResponse
}
import software.amazon.awssdk.services.pcs.{
  PcsAsyncClientBuilder,
  PcsAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.pcs.paginators.{
  ListComputeNodeGroupsPublisher,
  ListClustersPublisher,
  ListQueuesPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Pcs extends AspectSupport[Pcs] {
  val api: PcsAsyncClient
  def updateQueue(
      request: zio.aws.pcs.model.UpdateQueueRequest
  ): IO[AwsError, zio.aws.pcs.model.UpdateQueueResponse.ReadOnly]
  def deleteComputeNodeGroup(
      request: zio.aws.pcs.model.DeleteComputeNodeGroupRequest
  ): IO[AwsError, zio.aws.pcs.model.DeleteComputeNodeGroupResponse.ReadOnly]
  def listQueues(
      request: zio.aws.pcs.model.ListQueuesRequest
  ): ZStream[Any, AwsError, zio.aws.pcs.model.QueueSummary.ReadOnly]
  def listQueuesPaginated(
      request: zio.aws.pcs.model.ListQueuesRequest
  ): IO[AwsError, zio.aws.pcs.model.ListQueuesResponse.ReadOnly]
  def createCluster(
      request: zio.aws.pcs.model.CreateClusterRequest
  ): IO[AwsError, zio.aws.pcs.model.CreateClusterResponse.ReadOnly]
  def getCluster(
      request: zio.aws.pcs.model.GetClusterRequest
  ): IO[AwsError, ReadOnly]
  def deleteCluster(
      request: zio.aws.pcs.model.DeleteClusterRequest
  ): IO[AwsError, zio.aws.pcs.model.DeleteClusterResponse.ReadOnly]
  def registerComputeNodeGroupInstance(
      request: zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest
  ): IO[
    AwsError,
    zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.pcs.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def getComputeNodeGroup(
      request: zio.aws.pcs.model.GetComputeNodeGroupRequest
  ): IO[AwsError, zio.aws.pcs.model.GetComputeNodeGroupResponse.ReadOnly]
  def createQueue(
      request: zio.aws.pcs.model.CreateQueueRequest
  ): IO[AwsError, zio.aws.pcs.model.CreateQueueResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.pcs.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.pcs.model.ListTagsForResourceResponse.ReadOnly]
  def listClusters(
      request: zio.aws.pcs.model.ListClustersRequest
  ): ZStream[Any, AwsError, zio.aws.pcs.model.ClusterSummary.ReadOnly]
  def listClustersPaginated(
      request: zio.aws.pcs.model.ListClustersRequest
  ): IO[AwsError, zio.aws.pcs.model.ListClustersResponse.ReadOnly]
  def tagResource(
      request: zio.aws.pcs.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def updateComputeNodeGroup(
      request: zio.aws.pcs.model.UpdateComputeNodeGroupRequest
  ): IO[AwsError, zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly]
  def listComputeNodeGroups(
      request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly]
  def listComputeNodeGroupsPaginated(
      request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
  ): IO[AwsError, zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly]
  def createComputeNodeGroup(
      request: zio.aws.pcs.model.CreateComputeNodeGroupRequest
  ): IO[AwsError, zio.aws.pcs.model.CreateComputeNodeGroupResponse.ReadOnly]
  def getQueue(
      request: zio.aws.pcs.model.GetQueueRequest
  ): IO[AwsError, zio.aws.pcs.model.GetQueueResponse.ReadOnly]
  def deleteQueue(
      request: zio.aws.pcs.model.DeleteQueueRequest
  ): IO[AwsError, zio.aws.pcs.model.DeleteQueueResponse.ReadOnly]
}
object Pcs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Pcs] = customized(identity)
  def customized(
      customization: PcsAsyncClientBuilder => PcsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Pcs] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PcsAsyncClientBuilder => PcsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Pcs] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PcsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[PcsAsyncClient, PcsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[PcsAsyncClient, PcsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new PcsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class PcsImpl[R](
      override val api: PcsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Pcs
      with AwsServiceBase[R] {
    override val serviceName: String = "Pcs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PcsImpl[R1] = new PcsImpl(api, newAspect, r)
    def updateQueue(
        request: zio.aws.pcs.model.UpdateQueueRequest
    ): IO[AwsError, zio.aws.pcs.model.UpdateQueueResponse.ReadOnly] =
      asyncRequestResponse[UpdateQueueRequest, UpdateQueueResponse](
        "updateQueue",
        api.updateQueue
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.UpdateQueueResponse.wrap)
        .provideEnvironment(r)
    def deleteComputeNodeGroup(
        request: zio.aws.pcs.model.DeleteComputeNodeGroupRequest
    ): IO[AwsError, zio.aws.pcs.model.DeleteComputeNodeGroupResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteComputeNodeGroupRequest,
        DeleteComputeNodeGroupResponse
      ]("deleteComputeNodeGroup", api.deleteComputeNodeGroup)(
        request.buildAwsValue()
      ).map(zio.aws.pcs.model.DeleteComputeNodeGroupResponse.wrap)
        .provideEnvironment(r)
    def listQueues(
        request: zio.aws.pcs.model.ListQueuesRequest
    ): ZStream[Any, AwsError, zio.aws.pcs.model.QueueSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListQueuesRequest,
        QueueSummary,
        ListQueuesPublisher
      ]("listQueues", api.listQueuesPaginator, _.queues())(
        request.buildAwsValue()
      ).map(item => zio.aws.pcs.model.QueueSummary.wrap(item))
        .provideEnvironment(r)
    def listQueuesPaginated(
        request: zio.aws.pcs.model.ListQueuesRequest
    ): IO[AwsError, zio.aws.pcs.model.ListQueuesResponse.ReadOnly] =
      asyncRequestResponse[ListQueuesRequest, ListQueuesResponse](
        "listQueues",
        api.listQueues
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.ListQueuesResponse.wrap)
        .provideEnvironment(r)
    def createCluster(
        request: zio.aws.pcs.model.CreateClusterRequest
    ): IO[AwsError, zio.aws.pcs.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateClusterRequest, CreateClusterResponse](
        "createCluster",
        api.createCluster
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def getCluster(
        request: zio.aws.pcs.model.GetClusterRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetClusterRequest, GetClusterResponse](
        "getCluster",
        api.getCluster
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.GetClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: zio.aws.pcs.model.DeleteClusterRequest
    ): IO[AwsError, zio.aws.pcs.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteClusterRequest, DeleteClusterResponse](
        "deleteCluster",
        api.deleteCluster
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def registerComputeNodeGroupInstance(
        request: zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest
    ): IO[
      AwsError,
      zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterComputeNodeGroupInstanceRequest,
      RegisterComputeNodeGroupInstanceResponse
    ]("registerComputeNodeGroupInstance", api.registerComputeNodeGroupInstance)(
      request.buildAwsValue()
    ).map(zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.pcs.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getComputeNodeGroup(
        request: zio.aws.pcs.model.GetComputeNodeGroupRequest
    ): IO[AwsError, zio.aws.pcs.model.GetComputeNodeGroupResponse.ReadOnly] =
      asyncRequestResponse[
        GetComputeNodeGroupRequest,
        GetComputeNodeGroupResponse
      ]("getComputeNodeGroup", api.getComputeNodeGroup)(request.buildAwsValue())
        .map(zio.aws.pcs.model.GetComputeNodeGroupResponse.wrap)
        .provideEnvironment(r)
    def createQueue(
        request: zio.aws.pcs.model.CreateQueueRequest
    ): IO[AwsError, zio.aws.pcs.model.CreateQueueResponse.ReadOnly] =
      asyncRequestResponse[CreateQueueRequest, CreateQueueResponse](
        "createQueue",
        api.createQueue
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.CreateQueueResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.pcs.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.pcs.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.pcs.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listClusters(
        request: zio.aws.pcs.model.ListClustersRequest
    ): ZStream[Any, AwsError, zio.aws.pcs.model.ClusterSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListClustersRequest,
        ClusterSummary,
        ListClustersPublisher
      ]("listClusters", api.listClustersPaginator, _.clusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.pcs.model.ClusterSummary.wrap(item))
        .provideEnvironment(r)
    def listClustersPaginated(
        request: zio.aws.pcs.model.ListClustersRequest
    ): IO[AwsError, zio.aws.pcs.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[ListClustersRequest, ListClustersResponse](
        "listClusters",
        api.listClusters
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.pcs.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateComputeNodeGroup(
        request: zio.aws.pcs.model.UpdateComputeNodeGroupRequest
    ): IO[AwsError, zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateComputeNodeGroupRequest,
        UpdateComputeNodeGroupResponse
      ]("updateComputeNodeGroup", api.updateComputeNodeGroup)(
        request.buildAwsValue()
      ).map(zio.aws.pcs.model.UpdateComputeNodeGroupResponse.wrap)
        .provideEnvironment(r)
    def listComputeNodeGroups(
        request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListComputeNodeGroupsRequest,
      ComputeNodeGroupSummary,
      ListComputeNodeGroupsPublisher
    ](
      "listComputeNodeGroups",
      api.listComputeNodeGroupsPaginator,
      _.computeNodeGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.pcs.model.ComputeNodeGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listComputeNodeGroupsPaginated(
        request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
    ): IO[AwsError, zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        ListComputeNodeGroupsRequest,
        ListComputeNodeGroupsResponse
      ]("listComputeNodeGroups", api.listComputeNodeGroups)(
        request.buildAwsValue()
      ).map(zio.aws.pcs.model.ListComputeNodeGroupsResponse.wrap)
        .provideEnvironment(r)
    def createComputeNodeGroup(
        request: zio.aws.pcs.model.CreateComputeNodeGroupRequest
    ): IO[AwsError, zio.aws.pcs.model.CreateComputeNodeGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateComputeNodeGroupRequest,
        CreateComputeNodeGroupResponse
      ]("createComputeNodeGroup", api.createComputeNodeGroup)(
        request.buildAwsValue()
      ).map(zio.aws.pcs.model.CreateComputeNodeGroupResponse.wrap)
        .provideEnvironment(r)
    def getQueue(
        request: zio.aws.pcs.model.GetQueueRequest
    ): IO[AwsError, zio.aws.pcs.model.GetQueueResponse.ReadOnly] =
      asyncRequestResponse[GetQueueRequest, GetQueueResponse](
        "getQueue",
        api.getQueue
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.GetQueueResponse.wrap)
        .provideEnvironment(r)
    def deleteQueue(
        request: zio.aws.pcs.model.DeleteQueueRequest
    ): IO[AwsError, zio.aws.pcs.model.DeleteQueueResponse.ReadOnly] =
      asyncRequestResponse[DeleteQueueRequest, DeleteQueueResponse](
        "deleteQueue",
        api.deleteQueue
      )(request.buildAwsValue())
        .map(zio.aws.pcs.model.DeleteQueueResponse.wrap)
        .provideEnvironment(r)
  }
  def updateQueue(request: zio.aws.pcs.model.UpdateQueueRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.UpdateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQueue(request))
  def deleteComputeNodeGroup(
      request: zio.aws.pcs.model.DeleteComputeNodeGroupRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.DeleteComputeNodeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComputeNodeGroup(request))
  def listQueues(request: zio.aws.pcs.model.ListQueuesRequest): ZStream[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.QueueSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueues(request))
  def listQueuesPaginated(request: zio.aws.pcs.model.ListQueuesRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ListQueuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueuesPaginated(request))
  def createCluster(request: zio.aws.pcs.model.CreateClusterRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def getCluster(
      request: zio.aws.pcs.model.GetClusterRequest
  ): ZIO[zio.aws.pcs.Pcs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getCluster(request))
  def deleteCluster(request: zio.aws.pcs.model.DeleteClusterRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def registerComputeNodeGroupInstance(
      request: zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerComputeNodeGroupInstance(request))
  def untagResource(
      request: zio.aws.pcs.model.UntagResourceRequest
  ): ZIO[zio.aws.pcs.Pcs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getComputeNodeGroup(
      request: zio.aws.pcs.model.GetComputeNodeGroupRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.GetComputeNodeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComputeNodeGroup(request))
  def createQueue(request: zio.aws.pcs.model.CreateQueueRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.CreateQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueue(request))
  def listTagsForResource(
      request: zio.aws.pcs.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listClusters(request: zio.aws.pcs.model.ListClustersRequest): ZStream[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ClusterSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(
      request: zio.aws.pcs.model.ListClustersRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def tagResource(
      request: zio.aws.pcs.model.TagResourceRequest
  ): ZIO[zio.aws.pcs.Pcs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def updateComputeNodeGroup(
      request: zio.aws.pcs.model.UpdateComputeNodeGroupRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComputeNodeGroup(request))
  def listComputeNodeGroups(
      request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
  ): ZStream[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComputeNodeGroups(request))
  def listComputeNodeGroupsPaginated(
      request: zio.aws.pcs.model.ListComputeNodeGroupsRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComputeNodeGroupsPaginated(request))
  def createComputeNodeGroup(
      request: zio.aws.pcs.model.CreateComputeNodeGroupRequest
  ): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.CreateComputeNodeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComputeNodeGroup(request))
  def getQueue(request: zio.aws.pcs.model.GetQueueRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.GetQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueue(request))
  def deleteQueue(request: zio.aws.pcs.model.DeleteQueueRequest): ZIO[
    zio.aws.pcs.Pcs,
    AwsError,
    zio.aws.pcs.model.DeleteQueueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueue(request))
}
