package zio.aws.pcs
import zio.aws.pcs.model.GetClusterResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.pcs.PcsAsyncClient
import zio.aws.pcs.model.{
  RegisterComputeNodeGroupInstanceRequest,
  ListQueuesRequest,
  DeleteQueueRequest,
  UpdateQueueRequest,
  CreateQueueRequest,
  ListTagsForResourceRequest,
  GetComputeNodeGroupRequest,
  ListComputeNodeGroupsRequest,
  GetClusterRequest,
  CreateClusterRequest,
  DeleteClusterRequest,
  CreateComputeNodeGroupRequest,
  UpdateComputeNodeGroupRequest,
  UntagResourceRequest,
  GetQueueRequest,
  ListClustersRequest,
  TagResourceRequest,
  DeleteComputeNodeGroupRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object PcsMock extends Mock[Pcs] {
  object UpdateQueue
      extends Effect[
        UpdateQueueRequest,
        AwsError,
        zio.aws.pcs.model.UpdateQueueResponse.ReadOnly
      ]
  object DeleteComputeNodeGroup
      extends Effect[
        DeleteComputeNodeGroupRequest,
        AwsError,
        zio.aws.pcs.model.DeleteComputeNodeGroupResponse.ReadOnly
      ]
  object ListQueues
      extends Stream[
        ListQueuesRequest,
        AwsError,
        zio.aws.pcs.model.QueueSummary.ReadOnly
      ]
  object ListQueuesPaginated
      extends Effect[
        ListQueuesRequest,
        AwsError,
        zio.aws.pcs.model.ListQueuesResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.pcs.model.CreateClusterResponse.ReadOnly
      ]
  object GetCluster extends Effect[GetClusterRequest, AwsError, ReadOnly]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.pcs.model.DeleteClusterResponse.ReadOnly
      ]
  object RegisterComputeNodeGroupInstance
      extends Effect[
        RegisterComputeNodeGroupInstanceRequest,
        AwsError,
        zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetComputeNodeGroup
      extends Effect[
        GetComputeNodeGroupRequest,
        AwsError,
        zio.aws.pcs.model.GetComputeNodeGroupResponse.ReadOnly
      ]
  object CreateQueue
      extends Effect[
        CreateQueueRequest,
        AwsError,
        zio.aws.pcs.model.CreateQueueResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.pcs.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListClusters
      extends Stream[
        ListClustersRequest,
        AwsError,
        zio.aws.pcs.model.ClusterSummary.ReadOnly
      ]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.pcs.model.ListClustersResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object UpdateComputeNodeGroup
      extends Effect[
        UpdateComputeNodeGroupRequest,
        AwsError,
        zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly
      ]
  object ListComputeNodeGroups
      extends Stream[
        ListComputeNodeGroupsRequest,
        AwsError,
        zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly
      ]
  object ListComputeNodeGroupsPaginated
      extends Effect[
        ListComputeNodeGroupsRequest,
        AwsError,
        zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly
      ]
  object CreateComputeNodeGroup
      extends Effect[
        CreateComputeNodeGroupRequest,
        AwsError,
        zio.aws.pcs.model.CreateComputeNodeGroupResponse.ReadOnly
      ]
  object GetQueue
      extends Effect[
        GetQueueRequest,
        AwsError,
        zio.aws.pcs.model.GetQueueResponse.ReadOnly
      ]
  object DeleteQueue
      extends Effect[
        DeleteQueueRequest,
        AwsError,
        zio.aws.pcs.model.DeleteQueueResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Pcs] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Pcs] { rts =>
        zio.ZIO.succeed {
          new Pcs {
            val api: PcsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Pcs = this
            def updateQueue(
                request: UpdateQueueRequest
            ): IO[AwsError, zio.aws.pcs.model.UpdateQueueResponse.ReadOnly] =
              proxy(UpdateQueue, request)
            def deleteComputeNodeGroup(
                request: DeleteComputeNodeGroupRequest
            ): IO[
              AwsError,
              zio.aws.pcs.model.DeleteComputeNodeGroupResponse.ReadOnly
            ] = proxy(DeleteComputeNodeGroup, request)
            def listQueues(
                request: ListQueuesRequest
            ): ZStream[Any, AwsError, zio.aws.pcs.model.QueueSummary.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListQueues, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listQueuesPaginated(
                request: ListQueuesRequest
            ): IO[AwsError, zio.aws.pcs.model.ListQueuesResponse.ReadOnly] =
              proxy(ListQueuesPaginated, request)
            def createCluster(
                request: CreateClusterRequest
            ): IO[AwsError, zio.aws.pcs.model.CreateClusterResponse.ReadOnly] =
              proxy(CreateCluster, request)
            def getCluster(request: GetClusterRequest): IO[AwsError, ReadOnly] =
              proxy(GetCluster, request)
            def deleteCluster(
                request: DeleteClusterRequest
            ): IO[AwsError, zio.aws.pcs.model.DeleteClusterResponse.ReadOnly] =
              proxy(DeleteCluster, request)
            def registerComputeNodeGroupInstance(
                request: RegisterComputeNodeGroupInstanceRequest
            ): IO[
              AwsError,
              zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly
            ] = proxy(RegisterComputeNodeGroupInstance, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def getComputeNodeGroup(request: GetComputeNodeGroupRequest): IO[
              AwsError,
              zio.aws.pcs.model.GetComputeNodeGroupResponse.ReadOnly
            ] = proxy(GetComputeNodeGroup, request)
            def createQueue(
                request: CreateQueueRequest
            ): IO[AwsError, zio.aws.pcs.model.CreateQueueResponse.ReadOnly] =
              proxy(CreateQueue, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.pcs.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listClusters(request: ListClustersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.pcs.model.ClusterSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClusters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClustersPaginated(
                request: ListClustersRequest
            ): IO[AwsError, zio.aws.pcs.model.ListClustersResponse.ReadOnly] =
              proxy(ListClustersPaginated, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def updateComputeNodeGroup(
                request: UpdateComputeNodeGroupRequest
            ): IO[
              AwsError,
              zio.aws.pcs.model.UpdateComputeNodeGroupResponse.ReadOnly
            ] = proxy(UpdateComputeNodeGroup, request)
            def listComputeNodeGroups(
                request: ListComputeNodeGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComputeNodeGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComputeNodeGroupsPaginated(
                request: ListComputeNodeGroupsRequest
            ): IO[
              AwsError,
              zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly
            ] = proxy(ListComputeNodeGroupsPaginated, request)
            def createComputeNodeGroup(
                request: CreateComputeNodeGroupRequest
            ): IO[
              AwsError,
              zio.aws.pcs.model.CreateComputeNodeGroupResponse.ReadOnly
            ] = proxy(CreateComputeNodeGroup, request)
            def getQueue(
                request: GetQueueRequest
            ): IO[AwsError, zio.aws.pcs.model.GetQueueResponse.ReadOnly] =
              proxy(GetQueue, request)
            def deleteQueue(
                request: DeleteQueueRequest
            ): IO[AwsError, zio.aws.pcs.model.DeleteQueueResponse.ReadOnly] =
              proxy(DeleteQueue, request)
          }
        }
      }
    }
  }
}
