package zio.aws.pcs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.SyntheticTimestamp_date_time
import scala.jdk.CollectionConverters.*
final case class Cluster(
    name: String,
    id: String,
    arn: String,
    status: zio.aws.pcs.model.ClusterStatus,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    scheduler: zio.aws.pcs.model.Scheduler,
    size: zio.aws.pcs.model.Size,
    slurmConfiguration: Optional[zio.aws.pcs.model.ClusterSlurmConfiguration] =
      Optional.Absent,
    networking: zio.aws.pcs.model.Networking,
    endpoints: Optional[Iterable[zio.aws.pcs.model.Endpoint]] = Optional.Absent,
    errorInfo: Optional[Iterable[zio.aws.pcs.model.ErrorInfo]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pcs.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.Cluster
      .builder()
      .name(name: java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .status(status.unwrap)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .scheduler(scheduler.buildAwsValue())
      .size(size.unwrap)
      .optionallyWith(slurmConfiguration.map(value => value.buildAwsValue()))(
        _.slurmConfiguration
      )
      .networking(networking.buildAwsValue())
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        errorInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorInfo)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.Cluster.ReadOnly =
    zio.aws.pcs.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.Cluster = zio.aws.pcs.model.Cluster(
      name,
      id,
      arn,
      status,
      createdAt,
      modifiedAt,
      scheduler.asEditable,
      size,
      slurmConfiguration.map(value => value.asEditable),
      networking.asEditable,
      endpoints.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      errorInfo.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def name: String
    def id: String
    def arn: String
    def status: zio.aws.pcs.model.ClusterStatus
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def scheduler: zio.aws.pcs.model.Scheduler.ReadOnly
    def size: zio.aws.pcs.model.Size
    def slurmConfiguration
        : Optional[zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly]
    def networking: zio.aws.pcs.model.Networking.ReadOnly
    def endpoints: Optional[List[zio.aws.pcs.model.Endpoint.ReadOnly]]
    def errorInfo: Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.ClusterStatus] =
      ZIO.succeed(status)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getScheduler: ZIO[Any, Nothing, zio.aws.pcs.model.Scheduler.ReadOnly] =
      ZIO.succeed(scheduler)
    def getSize: ZIO[Any, Nothing, zio.aws.pcs.model.Size] = ZIO.succeed(size)
    def getSlurmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("slurmConfiguration", slurmConfiguration)
    def getNetworking
        : ZIO[Any, Nothing, zio.aws.pcs.model.Networking.ReadOnly] =
      ZIO.succeed(networking)
    def getEndpoints
        : ZIO[Any, AwsError, List[zio.aws.pcs.model.Endpoint.ReadOnly]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getErrorInfo
        : ZIO[Any, AwsError, List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.Cluster
  ) extends zio.aws.pcs.model.Cluster.ReadOnly {
    override val name: String = impl.name(): String
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val status: zio.aws.pcs.model.ClusterStatus =
      zio.aws.pcs.model.ClusterStatus.wrap(impl.status())
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val scheduler: zio.aws.pcs.model.Scheduler.ReadOnly =
      zio.aws.pcs.model.Scheduler.wrap(impl.scheduler())
    override val size: zio.aws.pcs.model.Size =
      zio.aws.pcs.model.Size.wrap(impl.size())
    override val slurmConfiguration
        : Optional[zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slurmConfiguration())
        .map(value => zio.aws.pcs.model.ClusterSlurmConfiguration.wrap(value))
    override val networking: zio.aws.pcs.model.Networking.ReadOnly =
      zio.aws.pcs.model.Networking.wrap(impl.networking())
    override val endpoints
        : Optional[List[zio.aws.pcs.model.Endpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.Endpoint.wrap(item)
          }.toList
        )
    override val errorInfo
        : Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.ErrorInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.Cluster
  ): zio.aws.pcs.model.Cluster.ReadOnly = new Wrapper(impl)
}
