package zio.aws.pcs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ClusterSlurmConfiguration(
    scaleDownIdleTimeInSeconds: Optional[
      ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger
    ] = Optional.Absent,
    slurmCustomSettings: Optional[
      Iterable[zio.aws.pcs.model.SlurmCustomSetting]
    ] = Optional.Absent,
    authKey: Optional[zio.aws.pcs.model.SlurmAuthKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration = {
    import ClusterSlurmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration
      .builder()
      .optionallyWith(
        scaleDownIdleTimeInSeconds.map(value =>
          ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger.unwrap(
            value
          ): Integer
        )
      )(_.scaleDownIdleTimeInSeconds)
      .optionallyWith(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slurmCustomSettings)
      .optionallyWith(authKey.map(value => value.buildAwsValue()))(_.authKey)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly =
    zio.aws.pcs.model.ClusterSlurmConfiguration.wrap(buildAwsValue())
}
object ClusterSlurmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ClusterSlurmConfiguration =
      zio.aws.pcs.model.ClusterSlurmConfiguration(
        scaleDownIdleTimeInSeconds.map(value => value),
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authKey.map(value => value.asEditable)
      )
    def scaleDownIdleTimeInSeconds
        : Optional[ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger]
    def slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]]
    def authKey: Optional[zio.aws.pcs.model.SlurmAuthKey.ReadOnly]
    def getScaleDownIdleTimeInSeconds: ZIO[
      Any,
      AwsError,
      ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger
    ] = AwsError.unwrapOptionField(
      "scaleDownIdleTimeInSeconds",
      scaleDownIdleTimeInSeconds
    )
    def getSlurmCustomSettings: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.SlurmCustomSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("slurmCustomSettings", slurmCustomSettings)
    def getAuthKey
        : ZIO[Any, AwsError, zio.aws.pcs.model.SlurmAuthKey.ReadOnly] =
      AwsError.unwrapOptionField("authKey", authKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration
  ) extends zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly {
    override val scaleDownIdleTimeInSeconds
        : Optional[ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scaleDownIdleTimeInSeconds())
        .map(value =>
          zio.aws.pcs.model.primitives
            .ClusterSlurmConfigurationScaleDownIdleTimeInSecondsInteger(value)
        )
    override val slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slurmCustomSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.SlurmCustomSetting.wrap(item)
          }.toList
        )
    override val authKey: Optional[zio.aws.pcs.model.SlurmAuthKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authKey())
        .map(value => zio.aws.pcs.model.SlurmAuthKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration
  ): zio.aws.pcs.model.ClusterSlurmConfiguration.ReadOnly = new Wrapper(impl)
}
