package zio.aws.pcs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ClusterSlurmConfigurationRequest(
    scaleDownIdleTimeInSeconds: Optional[
      ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
    ] = Optional.Absent,
    slurmCustomSettings: Optional[
      Iterable[zio.aws.pcs.model.SlurmCustomSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest = {
    import ClusterSlurmConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest
      .builder()
      .optionallyWith(
        scaleDownIdleTimeInSeconds.map(value =>
          ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
            .unwrap(value): Integer
        )
      )(_.scaleDownIdleTimeInSeconds)
      .optionallyWith(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slurmCustomSettings)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly =
    zio.aws.pcs.model.ClusterSlurmConfigurationRequest.wrap(buildAwsValue())
}
object ClusterSlurmConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ClusterSlurmConfigurationRequest =
      zio.aws.pcs.model.ClusterSlurmConfigurationRequest(
        scaleDownIdleTimeInSeconds.map(value => value),
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scaleDownIdleTimeInSeconds: Optional[
      ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
    ]
    def slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]]
    def getScaleDownIdleTimeInSeconds: ZIO[
      Any,
      AwsError,
      ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
    ] = AwsError.unwrapOptionField(
      "scaleDownIdleTimeInSeconds",
      scaleDownIdleTimeInSeconds
    )
    def getSlurmCustomSettings: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.SlurmCustomSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("slurmCustomSettings", slurmCustomSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest
  ) extends zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly {
    override val scaleDownIdleTimeInSeconds: Optional[
      ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleDownIdleTimeInSeconds())
      .map(value =>
        zio.aws.pcs.model.primitives
          .ClusterSlurmConfigurationRequestScaleDownIdleTimeInSecondsInteger(
            value
          )
      )
    override val slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slurmCustomSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.SlurmCustomSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest
  ): zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
