package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait ClusterStatus {
  def unwrap: software.amazon.awssdk.services.pcs.model.ClusterStatus
}
object ClusterStatus {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.ClusterStatus
  ): zio.aws.pcs.model.ClusterStatus = value match {
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.pcs.model.ClusterStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.CREATING
  }
  case object ACTIVE extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.UPDATING
  }
  case object DELETING extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.DELETING
  }
  case object CREATE_FAILED extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.DELETE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.pcs.model.ClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.ClusterStatus =
      software.amazon.awssdk.services.pcs.model.ClusterStatus.UPDATE_FAILED
  }
}
