package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ClusterSummary(
    name: String,
    id: String,
    arn: String,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    status: zio.aws.pcs.model.ClusterStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ClusterSummary = {
    import ClusterSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ClusterSummary
      .builder()
      .name(name: java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ClusterSummary.ReadOnly =
    zio.aws.pcs.model.ClusterSummary.wrap(buildAwsValue())
}
object ClusterSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ClusterSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ClusterSummary = zio.aws.pcs.model
      .ClusterSummary(name, id, arn, createdAt, modifiedAt, status)
    def name: String
    def id: String
    def arn: String
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def status: zio.aws.pcs.model.ClusterStatus
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.ClusterStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSummary
  ) extends zio.aws.pcs.model.ClusterSummary.ReadOnly {
    override val name: String = impl.name(): String
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val status: zio.aws.pcs.model.ClusterStatus =
      zio.aws.pcs.model.ClusterStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ClusterSummary
  ): zio.aws.pcs.model.ClusterSummary.ReadOnly = new Wrapper(impl)
}
