package zio.aws.pcs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.{
  SubnetId,
  AmiId,
  ComputeNodeGroupName,
  SyntheticTimestamp_date_time,
  InstanceProfileArn
}
import scala.jdk.CollectionConverters.*
final case class ComputeNodeGroup(
    name: ComputeNodeGroupName,
    id: String,
    arn: String,
    clusterId: String,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    status: zio.aws.pcs.model.ComputeNodeGroupStatus,
    amiId: Optional[AmiId] = Optional.Absent,
    subnetIds: Iterable[SubnetId],
    purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      Optional.Absent,
    customLaunchTemplate: zio.aws.pcs.model.CustomLaunchTemplate,
    iamInstanceProfileArn: InstanceProfileArn,
    scalingConfiguration: zio.aws.pcs.model.ScalingConfiguration,
    instanceConfigs: Iterable[zio.aws.pcs.model.InstanceConfig],
    spotOptions: Optional[zio.aws.pcs.model.SpotOptions] = Optional.Absent,
    slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration
    ] = Optional.Absent,
    errorInfo: Optional[Iterable[zio.aws.pcs.model.ErrorInfo]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ComputeNodeGroup = {
    import ComputeNodeGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroup
      .builder()
      .name(ComputeNodeGroupName.unwrap(name): java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .clusterId(clusterId: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .status(status.unwrap)
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(purchaseOption.map(value => value.unwrap))(
        _.purchaseOption
      )
      .customLaunchTemplate(customLaunchTemplate.buildAwsValue())
      .iamInstanceProfileArn(
        InstanceProfileArn.unwrap(iamInstanceProfileArn): java.lang.String
      )
      .scalingConfiguration(scalingConfiguration.buildAwsValue())
      .instanceConfigs(instanceConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(slurmConfiguration.map(value => value.buildAwsValue()))(
        _.slurmConfiguration
      )
      .optionallyWith(
        errorInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorInfo)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ComputeNodeGroup.ReadOnly =
    zio.aws.pcs.model.ComputeNodeGroup.wrap(buildAwsValue())
}
object ComputeNodeGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ComputeNodeGroup =
      zio.aws.pcs.model.ComputeNodeGroup(
        name,
        id,
        arn,
        clusterId,
        createdAt,
        modifiedAt,
        status,
        amiId.map(value => value),
        subnetIds,
        purchaseOption.map(value => value),
        customLaunchTemplate.asEditable,
        iamInstanceProfileArn,
        scalingConfiguration.asEditable,
        instanceConfigs.map { item =>
          item.asEditable
        },
        spotOptions.map(value => value.asEditable),
        slurmConfiguration.map(value => value.asEditable),
        errorInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ComputeNodeGroupName
    def id: String
    def arn: String
    def clusterId: String
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def status: zio.aws.pcs.model.ComputeNodeGroupStatus
    def amiId: Optional[AmiId]
    def subnetIds: List[SubnetId]
    def purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption]
    def customLaunchTemplate: zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly
    def iamInstanceProfileArn: InstanceProfileArn
    def scalingConfiguration: zio.aws.pcs.model.ScalingConfiguration.ReadOnly
    def instanceConfigs: List[zio.aws.pcs.model.InstanceConfig.ReadOnly]
    def spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly]
    def slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly
    ]
    def errorInfo: Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]]
    def getName: ZIO[Any, Nothing, ComputeNodeGroupName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getClusterId: ZIO[Any, Nothing, String] = ZIO.succeed(clusterId)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.ComputeNodeGroupStatus] =
      ZIO.succeed(status)
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getPurchaseOption
        : ZIO[Any, AwsError, zio.aws.pcs.model.PurchaseOption] =
      AwsError.unwrapOptionField("purchaseOption", purchaseOption)
    def getCustomLaunchTemplate
        : ZIO[Any, Nothing, zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly] =
      ZIO.succeed(customLaunchTemplate)
    def getIamInstanceProfileArn: ZIO[Any, Nothing, InstanceProfileArn] =
      ZIO.succeed(iamInstanceProfileArn)
    def getScalingConfiguration
        : ZIO[Any, Nothing, zio.aws.pcs.model.ScalingConfiguration.ReadOnly] =
      ZIO.succeed(scalingConfiguration)
    def getInstanceConfigs
        : ZIO[Any, Nothing, List[zio.aws.pcs.model.InstanceConfig.ReadOnly]] =
      ZIO.succeed(instanceConfigs)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.pcs.model.SpotOptions.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getSlurmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("slurmConfiguration", slurmConfiguration)
    def getErrorInfo
        : ZIO[Any, AwsError, List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroup
  ) extends zio.aws.pcs.model.ComputeNodeGroup.ReadOnly {
    override val name: ComputeNodeGroupName =
      zio.aws.pcs.model.primitives.ComputeNodeGroupName(impl.name())
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val clusterId: String = impl.clusterId(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val status: zio.aws.pcs.model.ComputeNodeGroupStatus =
      zio.aws.pcs.model.ComputeNodeGroupStatus.wrap(impl.status())
    override val amiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => zio.aws.pcs.model.primitives.AmiId(value))
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.pcs.model.primitives.SubnetId(item)
      }
      .toList
    override val purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.purchaseOption())
        .map(value => zio.aws.pcs.model.PurchaseOption.wrap(value))
    override val customLaunchTemplate
        : zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly =
      zio.aws.pcs.model.CustomLaunchTemplate.wrap(impl.customLaunchTemplate())
    override val iamInstanceProfileArn: InstanceProfileArn =
      zio.aws.pcs.model.primitives
        .InstanceProfileArn(impl.iamInstanceProfileArn())
    override val scalingConfiguration
        : zio.aws.pcs.model.ScalingConfiguration.ReadOnly =
      zio.aws.pcs.model.ScalingConfiguration.wrap(impl.scalingConfiguration())
    override val instanceConfigs
        : List[zio.aws.pcs.model.InstanceConfig.ReadOnly] = impl
      .instanceConfigs()
      .asScala
      .map { item =>
        zio.aws.pcs.model.InstanceConfig.wrap(item)
      }
      .toList
    override val spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value => zio.aws.pcs.model.SpotOptions.wrap(value))
    override val slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slurmConfiguration())
      .map(value =>
        zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.wrap(value)
      )
    override val errorInfo
        : Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.ErrorInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroup
  ): zio.aws.pcs.model.ComputeNodeGroup.ReadOnly = new Wrapper(impl)
}
