package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComputeNodeGroupConfiguration(
    computeNodeGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration = {
    import ComputeNodeGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration
      .builder()
      .optionallyWith(computeNodeGroupId.map(value => value: java.lang.String))(
        _.computeNodeGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly =
    zio.aws.pcs.model.ComputeNodeGroupConfiguration.wrap(buildAwsValue())
}
object ComputeNodeGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ComputeNodeGroupConfiguration =
      zio.aws.pcs.model
        .ComputeNodeGroupConfiguration(computeNodeGroupId.map(value => value))
    def computeNodeGroupId: Optional[String]
    def getComputeNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeNodeGroupId", computeNodeGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration
  ) extends zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly {
    override val computeNodeGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.computeNodeGroupId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration
  ): zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
