package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComputeNodeGroupSlurmConfiguration(
    slurmCustomSettings: Optional[
      Iterable[zio.aws.pcs.model.SlurmCustomSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration = {
    import ComputeNodeGroupSlurmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration
      .builder()
      .optionallyWith(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slurmCustomSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly =
    zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.wrap(buildAwsValue())
}
object ComputeNodeGroupSlurmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration =
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration(
        slurmCustomSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]]
    def getSlurmCustomSettings: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.SlurmCustomSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("slurmCustomSettings", slurmCustomSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration
  ) extends zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly {
    override val slurmCustomSettings
        : Optional[List[zio.aws.pcs.model.SlurmCustomSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slurmCustomSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.SlurmCustomSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSlurmConfiguration
  ): zio.aws.pcs.model.ComputeNodeGroupSlurmConfiguration.ReadOnly =
    new Wrapper(impl)
}
