package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  SyntheticTimestamp_date_time,
  ComputeNodeGroupName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ComputeNodeGroupSummary(
    name: ComputeNodeGroupName,
    id: String,
    arn: String,
    clusterId: String,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    status: zio.aws.pcs.model.ComputeNodeGroupStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary = {
    import ComputeNodeGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary
      .builder()
      .name(ComputeNodeGroupName.unwrap(name): java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .clusterId(clusterId: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly =
    zio.aws.pcs.model.ComputeNodeGroupSummary.wrap(buildAwsValue())
}
object ComputeNodeGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ComputeNodeGroupSummary =
      zio.aws.pcs.model.ComputeNodeGroupSummary(
        name,
        id,
        arn,
        clusterId,
        createdAt,
        modifiedAt,
        status
      )
    def name: ComputeNodeGroupName
    def id: String
    def arn: String
    def clusterId: String
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def status: zio.aws.pcs.model.ComputeNodeGroupStatus
    def getName: ZIO[Any, Nothing, ComputeNodeGroupName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getClusterId: ZIO[Any, Nothing, String] = ZIO.succeed(clusterId)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.ComputeNodeGroupStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary
  ) extends zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly {
    override val name: ComputeNodeGroupName =
      zio.aws.pcs.model.primitives.ComputeNodeGroupName(impl.name())
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val clusterId: String = impl.clusterId(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val status: zio.aws.pcs.model.ComputeNodeGroupStatus =
      zio.aws.pcs.model.ComputeNodeGroupStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary
  ): zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly = new Wrapper(impl)
}
