package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  TagValue,
  TagKey,
  SBClientToken,
  ClusterName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    clusterName: ClusterName,
    scheduler: zio.aws.pcs.model.SchedulerRequest,
    size: zio.aws.pcs.model.Size,
    networking: zio.aws.pcs.model.NetworkingRequest,
    slurmConfiguration: Optional[
      zio.aws.pcs.model.ClusterSlurmConfigurationRequest
    ] = Optional.Absent,
    clientToken: Optional[SBClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.CreateClusterRequest
      .builder()
      .clusterName(ClusterName.unwrap(clusterName): java.lang.String)
      .scheduler(scheduler.buildAwsValue())
      .size(size.unwrap)
      .networking(networking.buildAwsValue())
      .optionallyWith(slurmConfiguration.map(value => value.buildAwsValue()))(
        _.slurmConfiguration
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.CreateClusterRequest.ReadOnly =
    zio.aws.pcs.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.CreateClusterRequest =
      zio.aws.pcs.model.CreateClusterRequest(
        clusterName,
        scheduler.asEditable,
        size,
        networking.asEditable,
        slurmConfiguration.map(value => value.asEditable),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def clusterName: ClusterName
    def scheduler: zio.aws.pcs.model.SchedulerRequest.ReadOnly
    def size: zio.aws.pcs.model.Size
    def networking: zio.aws.pcs.model.NetworkingRequest.ReadOnly
    def slurmConfiguration
        : Optional[zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly]
    def clientToken: Optional[SBClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClusterName: ZIO[Any, Nothing, ClusterName] =
      ZIO.succeed(clusterName)
    def getScheduler
        : ZIO[Any, Nothing, zio.aws.pcs.model.SchedulerRequest.ReadOnly] =
      ZIO.succeed(scheduler)
    def getSize: ZIO[Any, Nothing, zio.aws.pcs.model.Size] = ZIO.succeed(size)
    def getNetworking
        : ZIO[Any, Nothing, zio.aws.pcs.model.NetworkingRequest.ReadOnly] =
      ZIO.succeed(networking)
    def getSlurmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("slurmConfiguration", slurmConfiguration)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.CreateClusterRequest
  ) extends zio.aws.pcs.model.CreateClusterRequest.ReadOnly {
    override val clusterName: ClusterName =
      zio.aws.pcs.model.primitives.ClusterName(impl.clusterName())
    override val scheduler: zio.aws.pcs.model.SchedulerRequest.ReadOnly =
      zio.aws.pcs.model.SchedulerRequest.wrap(impl.scheduler())
    override val size: zio.aws.pcs.model.Size =
      zio.aws.pcs.model.Size.wrap(impl.size())
    override val networking: zio.aws.pcs.model.NetworkingRequest.ReadOnly =
      zio.aws.pcs.model.NetworkingRequest.wrap(impl.networking())
    override val slurmConfiguration: Optional[
      zio.aws.pcs.model.ClusterSlurmConfigurationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slurmConfiguration())
      .map(value =>
        zio.aws.pcs.model.ClusterSlurmConfigurationRequest.wrap(value)
      )
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pcs.model.primitives
              .TagKey(key) -> zio.aws.pcs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.CreateClusterRequest
  ): zio.aws.pcs.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
