package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    cluster: Optional[zio.aws.pcs.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.CreateClusterResponse.ReadOnly =
    zio.aws.pcs.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.CreateClusterResponse = zio.aws.pcs.model
      .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.pcs.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.pcs.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.CreateClusterResponse
  ) extends zio.aws.pcs.model.CreateClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.pcs.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.pcs.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.CreateClusterResponse
  ): zio.aws.pcs.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
