package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  AmiId,
  ComputeNodeGroupName,
  TagValue,
  InstanceProfileArn,
  SBClientToken,
  ClusterIdentifier,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateComputeNodeGroupRequest(
    clusterIdentifier: ClusterIdentifier,
    computeNodeGroupName: ComputeNodeGroupName,
    amiId: Optional[AmiId] = Optional.Absent,
    subnetIds: Iterable[String],
    purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      Optional.Absent,
    customLaunchTemplate: zio.aws.pcs.model.CustomLaunchTemplate,
    iamInstanceProfileArn: InstanceProfileArn,
    scalingConfiguration: zio.aws.pcs.model.ScalingConfigurationRequest,
    instanceConfigs: Iterable[zio.aws.pcs.model.InstanceConfig],
    spotOptions: Optional[zio.aws.pcs.model.SpotOptions] = Optional.Absent,
    slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfigurationRequest
    ] = Optional.Absent,
    clientToken: Optional[SBClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest = {
    import CreateComputeNodeGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .computeNodeGroupName(
        ComputeNodeGroupName.unwrap(computeNodeGroupName): java.lang.String
      )
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(purchaseOption.map(value => value.unwrap))(
        _.purchaseOption
      )
      .customLaunchTemplate(customLaunchTemplate.buildAwsValue())
      .iamInstanceProfileArn(
        InstanceProfileArn.unwrap(iamInstanceProfileArn): java.lang.String
      )
      .scalingConfiguration(scalingConfiguration.buildAwsValue())
      .instanceConfigs(instanceConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(slurmConfiguration.map(value => value.buildAwsValue()))(
        _.slurmConfiguration
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.CreateComputeNodeGroupRequest.ReadOnly =
    zio.aws.pcs.model.CreateComputeNodeGroupRequest.wrap(buildAwsValue())
}
object CreateComputeNodeGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.CreateComputeNodeGroupRequest =
      zio.aws.pcs.model.CreateComputeNodeGroupRequest(
        clusterIdentifier,
        computeNodeGroupName,
        amiId.map(value => value),
        subnetIds,
        purchaseOption.map(value => value),
        customLaunchTemplate.asEditable,
        iamInstanceProfileArn,
        scalingConfiguration.asEditable,
        instanceConfigs.map { item =>
          item.asEditable
        },
        spotOptions.map(value => value.asEditable),
        slurmConfiguration.map(value => value.asEditable),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def computeNodeGroupName: ComputeNodeGroupName
    def amiId: Optional[AmiId]
    def subnetIds: List[String]
    def purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption]
    def customLaunchTemplate: zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly
    def iamInstanceProfileArn: InstanceProfileArn
    def scalingConfiguration
        : zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly
    def instanceConfigs: List[zio.aws.pcs.model.InstanceConfig.ReadOnly]
    def spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly]
    def slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ]
    def clientToken: Optional[SBClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getComputeNodeGroupName: ZIO[Any, Nothing, ComputeNodeGroupName] =
      ZIO.succeed(computeNodeGroupName)
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getPurchaseOption
        : ZIO[Any, AwsError, zio.aws.pcs.model.PurchaseOption] =
      AwsError.unwrapOptionField("purchaseOption", purchaseOption)
    def getCustomLaunchTemplate
        : ZIO[Any, Nothing, zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly] =
      ZIO.succeed(customLaunchTemplate)
    def getIamInstanceProfileArn: ZIO[Any, Nothing, InstanceProfileArn] =
      ZIO.succeed(iamInstanceProfileArn)
    def getScalingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly
    ] = ZIO.succeed(scalingConfiguration)
    def getInstanceConfigs
        : ZIO[Any, Nothing, List[zio.aws.pcs.model.InstanceConfig.ReadOnly]] =
      ZIO.succeed(instanceConfigs)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.pcs.model.SpotOptions.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getSlurmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("slurmConfiguration", slurmConfiguration)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest
  ) extends zio.aws.pcs.model.CreateComputeNodeGroupRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val computeNodeGroupName: ComputeNodeGroupName =
      zio.aws.pcs.model.primitives
        .ComputeNodeGroupName(impl.computeNodeGroupName())
    override val amiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => zio.aws.pcs.model.primitives.AmiId(value))
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val purchaseOption: Optional[zio.aws.pcs.model.PurchaseOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.purchaseOption())
        .map(value => zio.aws.pcs.model.PurchaseOption.wrap(value))
    override val customLaunchTemplate
        : zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly =
      zio.aws.pcs.model.CustomLaunchTemplate.wrap(impl.customLaunchTemplate())
    override val iamInstanceProfileArn: InstanceProfileArn =
      zio.aws.pcs.model.primitives
        .InstanceProfileArn(impl.iamInstanceProfileArn())
    override val scalingConfiguration
        : zio.aws.pcs.model.ScalingConfigurationRequest.ReadOnly =
      zio.aws.pcs.model.ScalingConfigurationRequest
        .wrap(impl.scalingConfiguration())
    override val instanceConfigs
        : List[zio.aws.pcs.model.InstanceConfig.ReadOnly] = impl
      .instanceConfigs()
      .asScala
      .map { item =>
        zio.aws.pcs.model.InstanceConfig.wrap(item)
      }
      .toList
    override val spotOptions: Optional[zio.aws.pcs.model.SpotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value => zio.aws.pcs.model.SpotOptions.wrap(value))
    override val slurmConfiguration: Optional[
      zio.aws.pcs.model.ComputeNodeGroupSlurmConfigurationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.slurmConfiguration())
      .map(value =>
        zio.aws.pcs.model.ComputeNodeGroupSlurmConfigurationRequest.wrap(value)
      )
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pcs.model.primitives
              .TagKey(key) -> zio.aws.pcs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.CreateComputeNodeGroupRequest
  ): zio.aws.pcs.model.CreateComputeNodeGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
