package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  TagValue,
  QueueName,
  SBClientToken,
  ClusterIdentifier,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateQueueRequest(
    clusterIdentifier: ClusterIdentifier,
    queueName: QueueName,
    computeNodeGroupConfigurations: Optional[
      Iterable[zio.aws.pcs.model.ComputeNodeGroupConfiguration]
    ] = Optional.Absent,
    clientToken: Optional[SBClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.CreateQueueRequest = {
    import CreateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.CreateQueueRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .queueName(QueueName.unwrap(queueName): java.lang.String)
      .optionallyWith(
        computeNodeGroupConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeNodeGroupConfigurations)
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.CreateQueueRequest.ReadOnly =
    zio.aws.pcs.model.CreateQueueRequest.wrap(buildAwsValue())
}
object CreateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.CreateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.CreateQueueRequest =
      zio.aws.pcs.model.CreateQueueRequest(
        clusterIdentifier,
        queueName,
        computeNodeGroupConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def queueName: QueueName
    def computeNodeGroupConfigurations: Optional[
      List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly]
    ]
    def clientToken: Optional[SBClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getQueueName: ZIO[Any, Nothing, QueueName] = ZIO.succeed(queueName)
    def getComputeNodeGroupConfigurations: ZIO[Any, AwsError, List[
      zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "computeNodeGroupConfigurations",
      computeNodeGroupConfigurations
    )
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.CreateQueueRequest
  ) extends zio.aws.pcs.model.CreateQueueRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val queueName: QueueName =
      zio.aws.pcs.model.primitives.QueueName(impl.queueName())
    override val computeNodeGroupConfigurations: Optional[
      List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.computeNodeGroupConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pcs.model.ComputeNodeGroupConfiguration.wrap(item)
        }.toList
      )
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pcs.model.primitives
              .TagKey(key) -> zio.aws.pcs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.CreateQueueRequest
  ): zio.aws.pcs.model.CreateQueueRequest.ReadOnly = new Wrapper(impl)
}
