package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomLaunchTemplate(id: String, version: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate = {
    import CustomLaunchTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate
      .builder()
      .id(id: java.lang.String)
      .version(version: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly =
    zio.aws.pcs.model.CustomLaunchTemplate.wrap(buildAwsValue())
}
object CustomLaunchTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.CustomLaunchTemplate =
      zio.aws.pcs.model.CustomLaunchTemplate(id, version)
    def id: String
    def version: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getVersion: ZIO[Any, Nothing, String] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate
  ) extends zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly {
    override val id: String = impl.id(): String
    override val version: String = impl.version(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.CustomLaunchTemplate
  ): zio.aws.pcs.model.CustomLaunchTemplate.ReadOnly = new Wrapper(impl)
}
