package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{SBClientToken, ClusterIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteClusterRequest(
    clusterIdentifier: ClusterIdentifier,
    clientToken: Optional[SBClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.DeleteClusterRequest = {
    import DeleteClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.DeleteClusterRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.DeleteClusterRequest.ReadOnly =
    zio.aws.pcs.model.DeleteClusterRequest.wrap(buildAwsValue())
}
object DeleteClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.DeleteClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.DeleteClusterRequest = zio.aws.pcs.model
      .DeleteClusterRequest(clusterIdentifier, clientToken.map(value => value))
    def clusterIdentifier: ClusterIdentifier
    def clientToken: Optional[SBClientToken]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.DeleteClusterRequest
  ) extends zio.aws.pcs.model.DeleteClusterRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.DeleteClusterRequest
  ): zio.aws.pcs.model.DeleteClusterRequest.ReadOnly = new Wrapper(impl)
}
