package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  SBClientToken,
  ComputeNodeGroupIdentifier,
  ClusterIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteComputeNodeGroupRequest(
    clusterIdentifier: ClusterIdentifier,
    computeNodeGroupIdentifier: ComputeNodeGroupIdentifier,
    clientToken: Optional[SBClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest = {
    import DeleteComputeNodeGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .computeNodeGroupIdentifier(
        ComputeNodeGroupIdentifier.unwrap(
          computeNodeGroupIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.DeleteComputeNodeGroupRequest.ReadOnly =
    zio.aws.pcs.model.DeleteComputeNodeGroupRequest.wrap(buildAwsValue())
}
object DeleteComputeNodeGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.DeleteComputeNodeGroupRequest =
      zio.aws.pcs.model.DeleteComputeNodeGroupRequest(
        clusterIdentifier,
        computeNodeGroupIdentifier,
        clientToken.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def computeNodeGroupIdentifier: ComputeNodeGroupIdentifier
    def clientToken: Optional[SBClientToken]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getComputeNodeGroupIdentifier
        : ZIO[Any, Nothing, ComputeNodeGroupIdentifier] =
      ZIO.succeed(computeNodeGroupIdentifier)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest
  ) extends zio.aws.pcs.model.DeleteComputeNodeGroupRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val computeNodeGroupIdentifier: ComputeNodeGroupIdentifier =
      zio.aws.pcs.model.primitives
        .ComputeNodeGroupIdentifier(impl.computeNodeGroupIdentifier())
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.DeleteComputeNodeGroupRequest
  ): zio.aws.pcs.model.DeleteComputeNodeGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
