package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  SBClientToken,
  QueueIdentifier,
  ClusterIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteQueueRequest(
    clusterIdentifier: ClusterIdentifier,
    queueIdentifier: QueueIdentifier,
    clientToken: Optional[SBClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.DeleteQueueRequest = {
    import DeleteQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.DeleteQueueRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .queueIdentifier(
        QueueIdentifier.unwrap(queueIdentifier): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => SBClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.DeleteQueueRequest.ReadOnly =
    zio.aws.pcs.model.DeleteQueueRequest.wrap(buildAwsValue())
}
object DeleteQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.DeleteQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.DeleteQueueRequest =
      zio.aws.pcs.model.DeleteQueueRequest(
        clusterIdentifier,
        queueIdentifier,
        clientToken.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def queueIdentifier: QueueIdentifier
    def clientToken: Optional[SBClientToken]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getQueueIdentifier: ZIO[Any, Nothing, QueueIdentifier] =
      ZIO.succeed(queueIdentifier)
    def getClientToken: ZIO[Any, AwsError, SBClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.DeleteQueueRequest
  ) extends zio.aws.pcs.model.DeleteQueueRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val queueIdentifier: QueueIdentifier =
      zio.aws.pcs.model.primitives.QueueIdentifier(impl.queueIdentifier())
    override val clientToken: Optional[SBClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.pcs.model.primitives.SBClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.DeleteQueueRequest
  ): zio.aws.pcs.model.DeleteQueueRequest.ReadOnly = new Wrapper(impl)
}
