package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    `type`: zio.aws.pcs.model.EndpointType,
    privateIpAddress: String,
    publicIpAddress: Optional[String] = Optional.Absent,
    port: String
) {
  def buildAwsValue(): software.amazon.awssdk.services.pcs.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.Endpoint
      .builder()
      .`type`(`type`.unwrap)
      .privateIpAddress(privateIpAddress: java.lang.String)
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .port(port: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.Endpoint.ReadOnly =
    zio.aws.pcs.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.Endpoint = zio.aws.pcs.model.Endpoint(
      `type`,
      privateIpAddress,
      publicIpAddress.map(value => value),
      port
    )
    def `type`: zio.aws.pcs.model.EndpointType
    def privateIpAddress: String
    def publicIpAddress: Optional[String]
    def port: String
    def getType: ZIO[Any, Nothing, zio.aws.pcs.model.EndpointType] =
      ZIO.succeed(`type`)
    def getPrivateIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getPort: ZIO[Any, Nothing, String] = ZIO.succeed(port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.Endpoint
  ) extends zio.aws.pcs.model.Endpoint.ReadOnly {
    override val `type`: zio.aws.pcs.model.EndpointType =
      zio.aws.pcs.model.EndpointType.wrap(impl.`type`())
    override val privateIpAddress: String = impl.privateIpAddress(): String
    override val publicIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpAddress())
      .map(value => value: String)
    override val port: String = impl.port(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.Endpoint
  ): zio.aws.pcs.model.Endpoint.ReadOnly = new Wrapper(impl)
}
