package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.pcs.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.EndpointType
  ): zio.aws.pcs.model.EndpointType = value match {
    case software.amazon.awssdk.services.pcs.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.EndpointType.SLURMCTLD =>
      val r = SLURMCTLD
      r
    case software.amazon.awssdk.services.pcs.model.EndpointType.SLURMDBD =>
      val r = SLURMDBD
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.EndpointType =
      software.amazon.awssdk.services.pcs.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object SLURMCTLD extends zio.aws.pcs.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.EndpointType =
      software.amazon.awssdk.services.pcs.model.EndpointType.SLURMCTLD
  }
  case object SLURMDBD extends zio.aws.pcs.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.EndpointType =
      software.amazon.awssdk.services.pcs.model.EndpointType.SLURMDBD
  }
}
