package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorInfo(
    code: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pcs.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ErrorInfo
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ErrorInfo.ReadOnly =
    zio.aws.pcs.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.ErrorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ErrorInfo = zio.aws.pcs.model
      .ErrorInfo(code.map(value => value), message.map(value => value))
    def code: Optional[String]
    def message: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ErrorInfo
  ) extends zio.aws.pcs.model.ErrorInfo.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ErrorInfo
  ): zio.aws.pcs.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
