package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.ClusterIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetClusterRequest(clusterIdentifier: ClusterIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.GetClusterRequest = {
    import GetClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.GetClusterRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.GetClusterRequest.ReadOnly =
    zio.aws.pcs.model.GetClusterRequest.wrap(buildAwsValue())
}
object GetClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.GetClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.GetClusterRequest =
      zio.aws.pcs.model.GetClusterRequest(clusterIdentifier)
    def clusterIdentifier: ClusterIdentifier
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.GetClusterRequest
  ) extends zio.aws.pcs.model.GetClusterRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.GetClusterRequest
  ): zio.aws.pcs.model.GetClusterRequest.ReadOnly = new Wrapper(impl)
}
