package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetClusterResponse(
    cluster: Optional[zio.aws.pcs.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.GetClusterResponse = {
    import GetClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.GetClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.GetClusterResponse.ReadOnly =
    zio.aws.pcs.model.GetClusterResponse.wrap(buildAwsValue())
}
object GetClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.GetClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.GetClusterResponse = zio.aws.pcs.model
      .GetClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.pcs.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.pcs.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.GetClusterResponse
  ) extends zio.aws.pcs.model.GetClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.pcs.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.pcs.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.GetClusterResponse
  ): zio.aws.pcs.model.GetClusterResponse.ReadOnly = new Wrapper(impl)
}
