package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{
  ComputeNodeGroupIdentifier,
  ClusterIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetComputeNodeGroupRequest(
    clusterIdentifier: ClusterIdentifier,
    computeNodeGroupIdentifier: ComputeNodeGroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest = {
    import GetComputeNodeGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .computeNodeGroupIdentifier(
        ComputeNodeGroupIdentifier.unwrap(
          computeNodeGroupIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.GetComputeNodeGroupRequest.ReadOnly =
    zio.aws.pcs.model.GetComputeNodeGroupRequest.wrap(buildAwsValue())
}
object GetComputeNodeGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.GetComputeNodeGroupRequest =
      zio.aws.pcs.model.GetComputeNodeGroupRequest(
        clusterIdentifier,
        computeNodeGroupIdentifier
      )
    def clusterIdentifier: ClusterIdentifier
    def computeNodeGroupIdentifier: ComputeNodeGroupIdentifier
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getComputeNodeGroupIdentifier
        : ZIO[Any, Nothing, ComputeNodeGroupIdentifier] =
      ZIO.succeed(computeNodeGroupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest
  ) extends zio.aws.pcs.model.GetComputeNodeGroupRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val computeNodeGroupIdentifier: ComputeNodeGroupIdentifier =
      zio.aws.pcs.model.primitives
        .ComputeNodeGroupIdentifier(impl.computeNodeGroupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.GetComputeNodeGroupRequest
  ): zio.aws.pcs.model.GetComputeNodeGroupRequest.ReadOnly = new Wrapper(impl)
}
