package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{QueueIdentifier, ClusterIdentifier}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetQueueRequest(
    clusterIdentifier: ClusterIdentifier,
    queueIdentifier: QueueIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.GetQueueRequest = {
    import GetQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.GetQueueRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .queueIdentifier(
        QueueIdentifier.unwrap(queueIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.GetQueueRequest.ReadOnly =
    zio.aws.pcs.model.GetQueueRequest.wrap(buildAwsValue())
}
object GetQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.GetQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.GetQueueRequest =
      zio.aws.pcs.model.GetQueueRequest(clusterIdentifier, queueIdentifier)
    def clusterIdentifier: ClusterIdentifier
    def queueIdentifier: QueueIdentifier
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getQueueIdentifier: ZIO[Any, Nothing, QueueIdentifier] =
      ZIO.succeed(queueIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.GetQueueRequest
  ) extends zio.aws.pcs.model.GetQueueRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val queueIdentifier: QueueIdentifier =
      zio.aws.pcs.model.primitives.QueueIdentifier(impl.queueIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.GetQueueRequest
  ): zio.aws.pcs.model.GetQueueRequest.ReadOnly = new Wrapper(impl)
}
