package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQueueResponse(
    queue: Optional[zio.aws.pcs.model.Queue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.GetQueueResponse = {
    import GetQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.GetQueueResponse
      .builder()
      .optionallyWith(queue.map(value => value.buildAwsValue()))(_.queue)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.GetQueueResponse.ReadOnly =
    zio.aws.pcs.model.GetQueueResponse.wrap(buildAwsValue())
}
object GetQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.GetQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.GetQueueResponse =
      zio.aws.pcs.model.GetQueueResponse(queue.map(value => value.asEditable))
    def queue: Optional[zio.aws.pcs.model.Queue.ReadOnly]
    def getQueue: ZIO[Any, AwsError, zio.aws.pcs.model.Queue.ReadOnly] =
      AwsError.unwrapOptionField("queue", queue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.GetQueueResponse
  ) extends zio.aws.pcs.model.GetQueueResponse.ReadOnly {
    override val queue: Optional[zio.aws.pcs.model.Queue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queue())
        .map(value => zio.aws.pcs.model.Queue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.GetQueueResponse
  ): zio.aws.pcs.model.GetQueueResponse.ReadOnly = new Wrapper(impl)
}
