package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstanceConfig(
    instanceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.InstanceConfig = {
    import InstanceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.InstanceConfig
      .builder()
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.InstanceConfig.ReadOnly =
    zio.aws.pcs.model.InstanceConfig.wrap(buildAwsValue())
}
object InstanceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.InstanceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.InstanceConfig =
      zio.aws.pcs.model.InstanceConfig(instanceType.map(value => value))
    def instanceType: Optional[String]
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.InstanceConfig
  ) extends zio.aws.pcs.model.InstanceConfig.ReadOnly {
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.InstanceConfig
  ): zio.aws.pcs.model.InstanceConfig.ReadOnly = new Wrapper(impl)
}
