package zio.aws.pcs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.MaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListClustersRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListClustersRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListClustersRequest.ReadOnly =
    zio.aws.pcs.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListClustersRequest =
      zio.aws.pcs.model.ListClustersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListClustersRequest
  ) extends zio.aws.pcs.model.ListClustersRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pcs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListClustersRequest
  ): zio.aws.pcs.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
