package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClustersResponse(
    clusters: Iterable[zio.aws.pcs.model.ClusterSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListClustersResponse
      .builder()
      .clusters(clusters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListClustersResponse.ReadOnly =
    zio.aws.pcs.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListClustersResponse =
      zio.aws.pcs.model.ListClustersResponse(
        clusters.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def clusters: List[zio.aws.pcs.model.ClusterSummary.ReadOnly]
    def nextToken: Optional[String]
    def getClusters
        : ZIO[Any, Nothing, List[zio.aws.pcs.model.ClusterSummary.ReadOnly]] =
      ZIO.succeed(clusters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListClustersResponse
  ) extends zio.aws.pcs.model.ListClustersResponse.ReadOnly {
    override val clusters: List[zio.aws.pcs.model.ClusterSummary.ReadOnly] =
      impl
        .clusters()
        .asScala
        .map { item =>
          zio.aws.pcs.model.ClusterSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListClustersResponse
  ): zio.aws.pcs.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
