package zio.aws.pcs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.{MaxResults, ClusterIdentifier}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListComputeNodeGroupsRequest(
    clusterIdentifier: ClusterIdentifier,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest = {
    import ListComputeNodeGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListComputeNodeGroupsRequest.ReadOnly =
    zio.aws.pcs.model.ListComputeNodeGroupsRequest.wrap(buildAwsValue())
}
object ListComputeNodeGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListComputeNodeGroupsRequest =
      zio.aws.pcs.model.ListComputeNodeGroupsRequest(
        clusterIdentifier,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest
  ) extends zio.aws.pcs.model.ListComputeNodeGroupsRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pcs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsRequest
  ): zio.aws.pcs.model.ListComputeNodeGroupsRequest.ReadOnly = new Wrapper(impl)
}
