package zio.aws.pcs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComputeNodeGroupsResponse(
    computeNodeGroups: Iterable[zio.aws.pcs.model.ComputeNodeGroupSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse = {
    import ListComputeNodeGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse
      .builder()
      .computeNodeGroups(computeNodeGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly =
    zio.aws.pcs.model.ListComputeNodeGroupsResponse.wrap(buildAwsValue())
}
object ListComputeNodeGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListComputeNodeGroupsResponse =
      zio.aws.pcs.model.ListComputeNodeGroupsResponse(
        computeNodeGroups.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def computeNodeGroups
        : List[zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly]
    def nextToken: Optional[String]
    def getComputeNodeGroups: ZIO[Any, Nothing, List[
      zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly
    ]] = ZIO.succeed(computeNodeGroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse
  ) extends zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly {
    override val computeNodeGroups
        : List[zio.aws.pcs.model.ComputeNodeGroupSummary.ReadOnly] = impl
      .computeNodeGroups()
      .asScala
      .map { item =>
        zio.aws.pcs.model.ComputeNodeGroupSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListComputeNodeGroupsResponse
  ): zio.aws.pcs.model.ListComputeNodeGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
