package zio.aws.pcs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.{MaxResults, ClusterIdentifier}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListQueuesRequest(
    clusterIdentifier: ClusterIdentifier,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListQueuesRequest = {
    import ListQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListQueuesRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListQueuesRequest.ReadOnly =
    zio.aws.pcs.model.ListQueuesRequest.wrap(buildAwsValue())
}
object ListQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListQueuesRequest =
      zio.aws.pcs.model.ListQueuesRequest(
        clusterIdentifier,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def clusterIdentifier: ClusterIdentifier
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListQueuesRequest
  ) extends zio.aws.pcs.model.ListQueuesRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.pcs.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListQueuesRequest
  ): zio.aws.pcs.model.ListQueuesRequest.ReadOnly = new Wrapper(impl)
}
