package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.pcs.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ListTagsForResourceRequest =
      zio.aws.pcs.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest
  ) extends zio.aws.pcs.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.pcs.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ListTagsForResourceRequest
  ): zio.aws.pcs.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
