package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait PurchaseOption {
  def unwrap: software.amazon.awssdk.services.pcs.model.PurchaseOption
}
object PurchaseOption {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.PurchaseOption
  ): zio.aws.pcs.model.PurchaseOption = value match {
    case software.amazon.awssdk.services.pcs.model.PurchaseOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.PurchaseOption.ONDEMAND =>
      val r = ONDEMAND
      r
    case software.amazon.awssdk.services.pcs.model.PurchaseOption.SPOT =>
      val r = SPOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.PurchaseOption {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.PurchaseOption =
      software.amazon.awssdk.services.pcs.model.PurchaseOption.UNKNOWN_TO_SDK_VERSION
  }
  case object ONDEMAND extends zio.aws.pcs.model.PurchaseOption {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.PurchaseOption =
      software.amazon.awssdk.services.pcs.model.PurchaseOption.ONDEMAND
  }
  case object SPOT extends zio.aws.pcs.model.PurchaseOption {
    override def unwrap
        : software.amazon.awssdk.services.pcs.model.PurchaseOption =
      software.amazon.awssdk.services.pcs.model.PurchaseOption.SPOT
  }
}
