package zio.aws.pcs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pcs.model.primitives.{SyntheticTimestamp_date_time, QueueName}
import scala.jdk.CollectionConverters.*
final case class Queue(
    name: QueueName,
    id: String,
    arn: String,
    clusterId: String,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    status: zio.aws.pcs.model.QueueStatus,
    computeNodeGroupConfigurations: Iterable[
      zio.aws.pcs.model.ComputeNodeGroupConfiguration
    ],
    errorInfo: Optional[Iterable[zio.aws.pcs.model.ErrorInfo]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pcs.model.Queue = {
    import Queue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.Queue
      .builder()
      .name(QueueName.unwrap(name): java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .clusterId(clusterId: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .status(status.unwrap)
      .computeNodeGroupConfigurations(computeNodeGroupConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        errorInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorInfo)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.Queue.ReadOnly =
    zio.aws.pcs.model.Queue.wrap(buildAwsValue())
}
object Queue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.Queue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.Queue = zio.aws.pcs.model.Queue(
      name,
      id,
      arn,
      clusterId,
      createdAt,
      modifiedAt,
      status,
      computeNodeGroupConfigurations.map { item =>
        item.asEditable
      },
      errorInfo.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def name: QueueName
    def id: String
    def arn: String
    def clusterId: String
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def status: zio.aws.pcs.model.QueueStatus
    def computeNodeGroupConfigurations
        : List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly]
    def errorInfo: Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]]
    def getName: ZIO[Any, Nothing, QueueName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getClusterId: ZIO[Any, Nothing, String] = ZIO.succeed(clusterId)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.QueueStatus] =
      ZIO.succeed(status)
    def getComputeNodeGroupConfigurations: ZIO[Any, Nothing, List[
      zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly
    ]] = ZIO.succeed(computeNodeGroupConfigurations)
    def getErrorInfo
        : ZIO[Any, AwsError, List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      AwsError.unwrapOptionField("errorInfo", errorInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.Queue
  ) extends zio.aws.pcs.model.Queue.ReadOnly {
    override val name: QueueName =
      zio.aws.pcs.model.primitives.QueueName(impl.name())
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val clusterId: String = impl.clusterId(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val status: zio.aws.pcs.model.QueueStatus =
      zio.aws.pcs.model.QueueStatus.wrap(impl.status())
    override val computeNodeGroupConfigurations
        : List[zio.aws.pcs.model.ComputeNodeGroupConfiguration.ReadOnly] = impl
      .computeNodeGroupConfigurations()
      .asScala
      .map { item =>
        zio.aws.pcs.model.ComputeNodeGroupConfiguration.wrap(item)
      }
      .toList
    override val errorInfo
        : Optional[List[zio.aws.pcs.model.ErrorInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pcs.model.ErrorInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.Queue
  ): zio.aws.pcs.model.Queue.ReadOnly = new Wrapper(impl)
}
