package zio.aws.pcs.model
import scala.jdk.CollectionConverters.*
sealed trait QueueStatus {
  def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus
}
object QueueStatus {
  def wrap(
      value: software.amazon.awssdk.services.pcs.model.QueueStatus
  ): zio.aws.pcs.model.QueueStatus = value match {
    case software.amazon.awssdk.services.pcs.model.QueueStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.pcs.model.QueueStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.CREATING
  }
  case object ACTIVE extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.UPDATING
  }
  case object DELETING extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.DELETING
  }
  case object CREATE_FAILED extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.DELETE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.pcs.model.QueueStatus {
    override def unwrap: software.amazon.awssdk.services.pcs.model.QueueStatus =
      software.amazon.awssdk.services.pcs.model.QueueStatus.UPDATE_FAILED
  }
}
