package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{SyntheticTimestamp_date_time, QueueName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class QueueSummary(
    name: QueueName,
    id: String,
    arn: String,
    clusterId: String,
    createdAt: SyntheticTimestamp_date_time,
    modifiedAt: SyntheticTimestamp_date_time,
    status: zio.aws.pcs.model.QueueStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.QueueSummary = {
    import QueueSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.QueueSummary
      .builder()
      .name(QueueName.unwrap(name): java.lang.String)
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .clusterId(clusterId: java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .modifiedAt(SyntheticTimestamp_date_time.unwrap(modifiedAt): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.QueueSummary.ReadOnly =
    zio.aws.pcs.model.QueueSummary.wrap(buildAwsValue())
}
object QueueSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pcs.model.QueueSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.QueueSummary = zio.aws.pcs.model
      .QueueSummary(name, id, arn, clusterId, createdAt, modifiedAt, status)
    def name: QueueName
    def id: String
    def arn: String
    def clusterId: String
    def createdAt: SyntheticTimestamp_date_time
    def modifiedAt: SyntheticTimestamp_date_time
    def status: zio.aws.pcs.model.QueueStatus
    def getName: ZIO[Any, Nothing, QueueName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getClusterId: ZIO[Any, Nothing, String] = ZIO.succeed(clusterId)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(modifiedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.pcs.model.QueueStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.QueueSummary
  ) extends zio.aws.pcs.model.QueueSummary.ReadOnly {
    override val name: QueueName =
      zio.aws.pcs.model.primitives.QueueName(impl.name())
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val clusterId: String = impl.clusterId(): String
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val modifiedAt: SyntheticTimestamp_date_time =
      zio.aws.pcs.model.primitives
        .SyntheticTimestamp_date_time(impl.modifiedAt())
    override val status: zio.aws.pcs.model.QueueStatus =
      zio.aws.pcs.model.QueueStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.QueueSummary
  ): zio.aws.pcs.model.QueueSummary.ReadOnly = new Wrapper(impl)
}
