package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.{BootstrapId, ClusterIdentifier}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterComputeNodeGroupInstanceRequest(
    clusterIdentifier: ClusterIdentifier,
    bootstrapId: BootstrapId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest = {
    import RegisterComputeNodeGroupInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest
      .builder()
      .clusterIdentifier(
        ClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .bootstrapId(BootstrapId.unwrap(bootstrapId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest.ReadOnly =
    zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest
      .wrap(buildAwsValue())
}
object RegisterComputeNodeGroupInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest =
      zio.aws.pcs.model
        .RegisterComputeNodeGroupInstanceRequest(clusterIdentifier, bootstrapId)
    def clusterIdentifier: ClusterIdentifier
    def bootstrapId: BootstrapId
    def getClusterIdentifier: ZIO[Any, Nothing, ClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getBootstrapId: ZIO[Any, Nothing, BootstrapId] =
      ZIO.succeed(bootstrapId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest
  ) extends zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest.ReadOnly {
    override val clusterIdentifier: ClusterIdentifier =
      zio.aws.pcs.model.primitives.ClusterIdentifier(impl.clusterIdentifier())
    override val bootstrapId: BootstrapId =
      zio.aws.pcs.model.primitives.BootstrapId(impl.bootstrapId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceRequest
  ): zio.aws.pcs.model.RegisterComputeNodeGroupInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
