package zio.aws.pcs.model
import zio.aws.pcs.model.primitives.SharedSecret
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterComputeNodeGroupInstanceResponse(
    nodeID: String,
    sharedSecret: SharedSecret,
    endpoints: Iterable[zio.aws.pcs.model.Endpoint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse = {
    import RegisterComputeNodeGroupInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse
      .builder()
      .nodeID(nodeID: java.lang.String)
      .sharedSecret(SharedSecret.unwrap(sharedSecret): java.lang.String)
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly =
    zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse
      .wrap(buildAwsValue())
}
object RegisterComputeNodeGroupInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse =
      zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse(
        nodeID,
        sharedSecret,
        endpoints.map { item =>
          item.asEditable
        }
      )
    def nodeID: String
    def sharedSecret: SharedSecret
    def endpoints: List[zio.aws.pcs.model.Endpoint.ReadOnly]
    def getNodeID: ZIO[Any, Nothing, String] = ZIO.succeed(nodeID)
    def getSharedSecret: ZIO[Any, Nothing, SharedSecret] =
      ZIO.succeed(sharedSecret)
    def getEndpoints
        : ZIO[Any, Nothing, List[zio.aws.pcs.model.Endpoint.ReadOnly]] =
      ZIO.succeed(endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse
  ) extends zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly {
    override val nodeID: String = impl.nodeID(): String
    override val sharedSecret: SharedSecret =
      zio.aws.pcs.model.primitives.SharedSecret(impl.sharedSecret())
    override val endpoints: List[zio.aws.pcs.model.Endpoint.ReadOnly] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.pcs.model.Endpoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.RegisterComputeNodeGroupInstanceResponse
  ): zio.aws.pcs.model.RegisterComputeNodeGroupInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
