package zio.aws.pcs.model
import java.lang.Integer
import zio.aws.pcs.model.primitives.{
  ScalingConfigurationMaxInstanceCountInteger,
  ScalingConfigurationMinInstanceCountInteger
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScalingConfiguration(
    minInstanceCount: ScalingConfigurationMinInstanceCountInteger,
    maxInstanceCount: ScalingConfigurationMaxInstanceCountInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pcs.model.ScalingConfiguration = {
    import ScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pcs.model.ScalingConfiguration
      .builder()
      .minInstanceCount(
        ScalingConfigurationMinInstanceCountInteger.unwrap(
          minInstanceCount
        ): Integer
      )
      .maxInstanceCount(
        ScalingConfigurationMaxInstanceCountInteger.unwrap(
          maxInstanceCount
        ): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.pcs.model.ScalingConfiguration.ReadOnly =
    zio.aws.pcs.model.ScalingConfiguration.wrap(buildAwsValue())
}
object ScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pcs.model.ScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pcs.model.ScalingConfiguration =
      zio.aws.pcs.model.ScalingConfiguration(minInstanceCount, maxInstanceCount)
    def minInstanceCount: ScalingConfigurationMinInstanceCountInteger
    def maxInstanceCount: ScalingConfigurationMaxInstanceCountInteger
    def getMinInstanceCount
        : ZIO[Any, Nothing, ScalingConfigurationMinInstanceCountInteger] =
      ZIO.succeed(minInstanceCount)
    def getMaxInstanceCount
        : ZIO[Any, Nothing, ScalingConfigurationMaxInstanceCountInteger] =
      ZIO.succeed(maxInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pcs.model.ScalingConfiguration
  ) extends zio.aws.pcs.model.ScalingConfiguration.ReadOnly {
    override val minInstanceCount: ScalingConfigurationMinInstanceCountInteger =
      zio.aws.pcs.model.primitives
        .ScalingConfigurationMinInstanceCountInteger(impl.minInstanceCount())
    override val maxInstanceCount: ScalingConfigurationMaxInstanceCountInteger =
      zio.aws.pcs.model.primitives
        .ScalingConfigurationMaxInstanceCountInteger(impl.maxInstanceCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pcs.model.ScalingConfiguration
  ): zio.aws.pcs.model.ScalingConfiguration.ReadOnly = new Wrapper(impl)
}
